/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.model.baked.chiseled;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import mod.chiselsandbits.api.blockinformation.BlockInformation;
import mod.chiselsandbits.api.config.IClientConfiguration;
import mod.chiselsandbits.api.item.multistate.IMultiStateItemStack;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.accessor.identifier.IAreaShapeIdentifier;
import mod.chiselsandbits.api.neighborhood.IBlockNeighborhood;
import mod.chiselsandbits.api.neighborhood.IBlockNeighborhoodBuilder;
import mod.chiselsandbits.api.profiling.IProfilerSection;
import mod.chiselsandbits.api.util.VectorUtils;
import mod.chiselsandbits.client.model.baked.chiseled.ChiselRenderType;
import mod.chiselsandbits.client.model.baked.chiseled.ChiseledBlockBakedModel;
import mod.chiselsandbits.profiling.ProfilingManager;
import mod.chiselsandbits.utils.SimpleMaxSizedCache;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChiseledBlockBakedModelManager {
    private static final ChiseledBlockBakedModelManager INSTANCE = new ChiseledBlockBakedModelManager();
    private final SimpleMaxSizedCache<Key, ChiseledBlockBakedModel> cache = new SimpleMaxSizedCache(() -> IClientConfiguration.getInstance().getModelCacheSize().get() * (long)class_1921.method_22720().size());

    private ChiseledBlockBakedModelManager() {
    }

    public static ChiseledBlockBakedModelManager getInstance() {
        return INSTANCE;
    }

    public void clearCache() {
        this.cache.clear();
    }

    public Optional<ChiseledBlockBakedModel> get(IMultiStateItemStack multiStateItemStack, ChiselRenderType renderType) {
        try (IProfilerSection ignored = ProfilingManager.getInstance().withSection("Item based chiseled block model");){
            Optional<ChiseledBlockBakedModel> optional = Optional.of(this.get(multiStateItemStack, multiStateItemStack.getStatistics().getPrimaryState(), renderType, null, null, class_2338.field_10980));
            return optional;
        }
    }

    public ChiseledBlockBakedModel get(IAreaAccessor accessor, BlockInformation primaryState, ChiselRenderType renderType) {
        return this.get(accessor, primaryState, renderType, null, null, class_2338.field_10980);
    }

    public ChiseledBlockBakedModel get(IAreaAccessor accessor, BlockInformation primaryState, ChiselRenderType renderType, @Nullable Function<class_2350, BlockInformation> neighborhoodBlockInformationProvider, @Nullable Function<class_2350, IAreaAccessor> neighborhoodAreaAccessorProvider, @NotNull class_2338 position) {
        try (IProfilerSection ignored1 = ProfilingManager.getInstance().withSection("Block based chiseled block model");){
            long primaryStateRenderSeed = primaryState.getBlockState().method_26190(position);
            Key key = new Key(accessor.createNewShapeIdentifier(), primaryState, renderType, IBlockNeighborhoodBuilder.getInstance().build(neighborhoodBlockInformationProvider, neighborhoodAreaAccessorProvider), primaryStateRenderSeed);
            ChiseledBlockBakedModel chiseledBlockBakedModel = this.cache.get(key, () -> {
                try (IProfilerSection ignored3 = ProfilingManager.getInstance().withSection("Cache mis");){
                    ChiseledBlockBakedModel chiseledBlockBakedModel = new ChiseledBlockBakedModel(primaryState, renderType, accessor, targetOffset -> {
                        IAreaAccessor neighborAccessor;
                        class_243 nominalTargetOffset = class_243.field_1353.method_1019(targetOffset);
                        class_2338 nominalTargetBlockOffset = new class_2338(nominalTargetOffset);
                        class_243 inBlockOffset = nominalTargetOffset.method_1020(class_243.method_24954((class_2382)nominalTargetBlockOffset));
                        class_243 inBlockOffsetTarget = VectorUtils.makePositive(inBlockOffset);
                        class_2350 offsetDirection = class_2350.method_10147((float)nominalTargetBlockOffset.method_10263(), (float)nominalTargetBlockOffset.method_10264(), (float)nominalTargetBlockOffset.method_10260());
                        if (targetOffset.method_10216() >= 0.0 && targetOffset.method_10216() < 1.0 && targetOffset.method_10214() >= 0.0 && targetOffset.method_10214() < 1.0 && targetOffset.method_10215() >= 0.0 && targetOffset.method_10215() < 1.0) {
                            neighborAccessor = accessor;
                        } else {
                            IAreaAccessor iAreaAccessor = neighborAccessor = neighborhoodAreaAccessorProvider != null ? (IAreaAccessor)neighborhoodAreaAccessorProvider.apply(offsetDirection) : null;
                        }
                        if (neighborAccessor != null) {
                            return neighborAccessor.getInAreaTarget(inBlockOffsetTarget).map(IStateEntryInfo::getBlockInformation).orElse(BlockInformation.AIR);
                        }
                        return neighborhoodBlockInformationProvider != null ? (BlockInformation)neighborhoodBlockInformationProvider.apply(offsetDirection) : BlockInformation.AIR;
                    }, primaryStateRenderSeed);
                    return chiseledBlockBakedModel;
                }
            });
            return chiseledBlockBakedModel;
        }
    }

    private static final class Key {
        private final IAreaShapeIdentifier identifier;
        private final BlockInformation primaryState;
        private final ChiselRenderType renderType;
        private final IBlockNeighborhood neighborhood;
        private final long renderSeed;

        private Key(IAreaShapeIdentifier identifier, BlockInformation primaryState, ChiselRenderType renderType, IBlockNeighborhood neighborhood, long renderSeed) {
            this.identifier = identifier;
            this.primaryState = primaryState;
            this.renderType = renderType;
            this.neighborhood = neighborhood;
            this.renderSeed = renderSeed;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key key = (Key)o;
            if (this.renderSeed != key.renderSeed) {
                return false;
            }
            if (!Objects.equals(this.identifier, key.identifier)) {
                return false;
            }
            if (!Objects.equals(this.primaryState, key.primaryState)) {
                return false;
            }
            if (this.renderType != key.renderType) {
                return false;
            }
            return Objects.equals(this.neighborhood, key.neighborhood);
        }

        public int hashCode() {
            int result = this.identifier != null ? this.identifier.hashCode() : 0;
            result = 31 * result + (this.primaryState != null ? this.primaryState.hashCode() : 0);
            result = 31 * result + (this.renderType != null ? this.renderType.hashCode() : 0);
            result = 31 * result + (this.neighborhood != null ? this.neighborhood.hashCode() : 0);
            result = 31 * result + (int)(this.renderSeed ^ this.renderSeed >>> 32);
            return result;
        }
    }
}

